/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.envivio;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.device.envivio.EnvivioServiceClass;
import com.tandbergtv.workflow.device.envivio.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class EnvivioAdaptor
implements IAdaptor {
    private static final Logger logger = Logger.getLogger(EnvivioAdaptor.class);
    private static final String LAUNCHJOB = "01ea01";
    private static final String GETJOBSTATUS = "01ea02";
    private static final String PRESETID = "presetId";
    private static final String JOBID = "JobId";
    private static final String STATUS = "Status";
    private static final String PERCENT = "percent";
    private static final String COMPLETION = "Completion";
    private static final String ERRORMESSAGE = "error-message";
    private static final String INPUTFILENAME = "inputFilename";
    private static final String OUTPUTFILENAME = "outputFilename";
    private static final String varName1 = "varName1";
    private static final String varName2 = "varName2";
    private static final String varName3 = "varName3";
    private static final String varValue1 = "varValue1";
    private static final String varValue2 = "varValue2";
    private static final String varValue3 = "varValue3";
    private static final List<String> messages = Arrays.asList("01ea01", "01ea02");
    IAdaptorConfiguration conf = null;

    public boolean canDeliver(IAdaptorRequest arg0) {
        try {
            WPCLConverter converter = new WPCLConverter();
            WorkflowMessage wfsMessage = converter.convert(arg0.getMessage());
            if (messages.contains(wfsMessage.getMessageUID().getUID())) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to handle message " + arg0.getMessage().getPayload().getContent()), (Throwable)ex);
        }
        return false;
    }

    public void init(IAdaptorConfiguration arg0) {
        this.conf = arg0;
        logger.info((Object)"Initialized");
    }

    public IAdaptorResponse transmit(IAdaptorRequest iar) throws AdaptorException {
        IAdaptorResponse response = null;
        WorkflowMessage message = null;
        try {
            message = new WPCLConverter().convert(iar.getMessage());
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
        IMessageUID messageUID = message.getMessageUID();
        logger.debug((Object)("Processing message[" + messageUID.getUID() + "] - " + messageUID.getName()));
        String url = DeviceTypeUtil.getConnectionString((IDevice)((IDevice)iar.getDestinations().get(0)));
        if (messageUID.getUID().equals(LAUNCHJOB)) {
            response = this.launchjob(message, url);
        } else if (messageUID.getUID().equals(GETJOBSTATUS)) {
            response = this.GetJobStatus(message, url);
        }
        return response;
    }

    private IAdaptorResponse GetJobStatus(WorkflowMessage message, String url) {
        String state = "null";
        String percent = "0";
        String reason = null;
        boolean badState = false;
        try {
            EnvivioServiceClass envivioInt = new EnvivioServiceClass(url);
            EnvivioServiceClass.GetJobStatus jobStatusRequest = new EnvivioServiceClass.GetJobStatus();
            String jobid = message.getValue(JOBID);
            jobStatusRequest.setJobid(jobid);
            EnvivioServiceClass.GetJobStatusResponse jobStatusReposne = envivioInt.getJobStatus(jobStatusRequest);
            EnvivioServiceClass.Jobstatusinfolist list = jobStatusReposne.getInfos();
            state = jobStatusReposne.getState();
            if (list.getInfo() != null) {
                if (list.getInfo().length > 0) {
                    for (EnvivioServiceClass.Jobstatusinfo j : list.getInfo()) {
                        logger.debug((Object)("j.getName()" + j.getName()));
                        if (j.getName().equalsIgnoreCase(COMPLETION)) {
                            logger.debug((Object)("JobStatusInfo[] has completion tag:" + j.getValue()));
                            percent = j.getValue();
                            continue;
                        }
                        if (j.getName().equalsIgnoreCase("error")) {
                            reason = j.getValue();
                            logger.debug((Object)("JobStatusInfo[] has error tag, reason =" + reason));
                            break;
                        }
                        reason = j.getValue();
                    }
                } else {
                    logger.debug((Object)"JobStatusInfo[] is empty");
                    reason = "JobStatusInfo[] is empty";
                }
            } else {
                logger.debug((Object)("State is " + state + " and JobStatusInfo[] is NULL"));
                reason = "No JobStatusInfo provided by Envivio System";
            }
            if (state.equalsIgnoreCase("success")) {
                percent = "100";
                reason = null;
            } else if (state.equalsIgnoreCase("error")) {
                badState = true;
            } else if (state.equalsIgnoreCase("canceled") || state.equalsIgnoreCase("canceling")) {
                reason = "Transcoding job has been canceled by the server";
                badState = true;
            }
            if (badState) {
                WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
                responseMessage.putValue(STATUS, state);
                responseMessage.putValue(COMPLETION, percent);
                if (reason != null) {
                    responseMessage.putValue(ERRORMESSAGE, reason);
                }
                responseMessage.setSource(null);
                return this.transform(responseMessage);
            }
        }
        catch (AxisFault e) {
            return this.processException((Exception)((Object)e), message);
        }
        catch (RemoteException e) {
            return this.processException(e, message);
        }
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        Double b = Double.parseDouble(percent);
        if (b.intValue() < 100) {
            WPCLCommand command = new WPCLCommand("task-update");
            command.addParameter(PERCENT, String.valueOf(b.intValue()));
            responseMessage.setCommand(command);
        }
        responseMessage.putValue(STATUS, state);
        responseMessage.putValue(COMPLETION, String.valueOf(b.intValue()));
        if (reason != null) {
            responseMessage.putValue("INFO", reason);
        }
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse launchjob(WorkflowMessage message, String url) {
        String jobId = null;
        String preset = message.getValue(PRESETID);
        String inputFilename = message.getValue(INPUTFILENAME);
        String outputFilename = message.getValue(OUTPUTFILENAME);
        String var1 = message.getValue(varName1);
        String val1 = message.getValue(varValue1);
        String var2 = message.getValue(varName2);
        String val2 = message.getValue(varValue2);
        String var3 = message.getValue(varName3);
        String val3 = message.getValue(varValue3);
        boolean validFileURL = this.validateFileUrl(inputFilename);
        boolean bl = validFileURL = validFileURL && this.validateFileUrl(outputFilename);
        if (inputFilename == null || preset == null || outputFilename == null || !validFileURL) {
            WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            if (!validFileURL) {
                responseMessage.putValue(ERRORMESSAGE, "input or output file url are invalid");
            } else {
                responseMessage.putValue(ERRORMESSAGE, "one of the mandatory param is null");
            }
            return this.transform(responseMessage);
        }
        EnvivioServiceClass.Params params = new EnvivioServiceClass.Params();
        EnvivioServiceClass.Param param = new EnvivioServiceClass.Param();
        param.setName(INPUTFILENAME.toLowerCase());
        param.setValue(inputFilename);
        params.addParam(param);
        param = new EnvivioServiceClass.Param();
        param.setName(OUTPUTFILENAME.toLowerCase());
        param.setValue(outputFilename);
        params.addParam(param);
        if (var1 != null && !var1.isEmpty()) {
            param = new EnvivioServiceClass.Param();
            param.setName(var1);
            param.setValue(val1);
            params.addParam(param);
        }
        if (var2 != null && !var2.isEmpty()) {
            param = new EnvivioServiceClass.Param();
            param.setName(var2);
            param.setValue(val2);
            params.addParam(param);
        }
        if (var3 != null && !var3.isEmpty()) {
            param = new EnvivioServiceClass.Param();
            param.setName(var3);
            param.setValue(val3);
            params.addParam(param);
        }
        try {
            String key = message.getKey().toString();
            EnvivioServiceClass envivioInt = new EnvivioServiceClass(url);
            EnvivioServiceClass.LaunchJob lJRequest = new EnvivioServiceClass.LaunchJob();
            lJRequest.setPresetid(preset);
            lJRequest.setJobname(key + "-" + UUID.randomUUID().toString());
            lJRequest.setJobparams(params);
            EnvivioServiceClass.LaunchJobResponse lJResponse = envivioInt.launchJob(lJRequest);
            jobId = lJResponse.getJobid();
            logger.debug((Object)jobId);
        }
        catch (AxisFault e) {
            return this.processException((Exception)((Object)e), message);
        }
        catch (RemoteException e) {
            return this.processException(e, message);
        }
        if (jobId == null) {
            WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
            responseMessage.putValue(ERRORMESSAGE, "JobId received from Envivio system is 'null'");
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        responseMessage.putValue(JOBID, jobId);
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse processException(Exception e, WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
        responseMessage.putValue(STATUS, "Error");
        responseMessage.putValue(ERRORMESSAGE, e.getMessage());
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private boolean validateFileUrl(String url) {
        Pattern p = Pattern.compile("^file://");
        Matcher m = p.matcher(url);
        return m.find();
    }

    private IAdaptorResponse transform(WorkflowMessage responseMessage) {
        Marshaller m = Marshaller.newMarshaller();
        StringWriter sw = new StringWriter();
        try {
            Document responseDoc = m.marshal(responseMessage);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(responseDoc.getDocumentElement()), new StreamResult(sw));
        }
        catch (MarshalException e) {
            logger.error((Object)e);
        }
        catch (TransformerException e) {
            logger.error((Object)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)e);
        }
        MessageImpl iMessage = new MessageImpl((IPayload)new StringPayload(sw.getBuffer().toString()));
        return new AdaptorResponseImpl((IMessage)iMessage);
    }

    public void destroy() {
    }
}

