/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.envivio;

import com.tandbergtv.workflow.device.envivio.EnvivioServiceClass;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractHeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;

public class EnvivioHBS
extends AbstractHeartBeatStrategy
implements Runnable {
    private static final Logger logger = Logger.getLogger(EnvivioHBS.class);

    protected Runnable getHeartBeatCommand() {
        return this;
    }

    @Override
    public void run() {
        Resource hbResource = this.getResource();
        String connectionString = hbResource.getHeartbeatConnectionString();
        String name = hbResource.getName();
        if (this.getContent(connectionString)) {
            logger.debug((Object)("EnvivioHBS.run... HB for " + name + " is Successful"));
            this.fireHeartBeatSuccessEvent(this.createEvent("HB for " + name + "is Successful"));
        } else {
            logger.debug((Object)("EnvivioHBS.run...   " + name + " not available"));
            this.fireHeartBeatFailureEvent(this.createEvent("EnvivioHBS not available"));
        }
    }

    private ResourceHeartBeatEvent createEvent(String msg) {
        ResourceHeartBeatEvent event = new ResourceHeartBeatEvent((Object)this, this.getResource(), msg);
        return event;
    }

    private boolean getContent(String connectionString) {
        try {
            EnvivioServiceClass envivio = new EnvivioServiceClass(connectionString);
            EnvivioServiceClass.GetStatus request = new EnvivioServiceClass.GetStatus();
            EnvivioServiceClass.GetStatusResponse response = envivio.getStatus(request);
            logger.debug((Object)("Response : " + response.getStatus()));
            if (response != null && (response.getStatus().equalsIgnoreCase("Standby") || response.getStatus().equalsIgnoreCase("Started"))) {
                return true;
            }
        }
        catch (AxisFault e) {
            logger.warn((Object)"Heartbeat failed", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Heartbeat failed", (Throwable)e);
        }
        return false;
    }
}

