/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.XMLTemplateHandler;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubmitJobTransformer
extends XMLTemplateHandler {
    private static final String OUTPUT_TAG_SUFFIX = "-output-dir";
    private static final String OUTPUT_TAG_WPCL_KEY = "format";
    private static final String DEST_DIR_WPCL_KEY = "dest-dir";
    private static final String JOB_PROFILE_WPCL_KEY = "job-profile";
    private static final Logger logger = Logger.getLogger(SubmitJobTransformer.class);

    public SubmitJobTransformer() {
    }

    public SubmitJobTransformer(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        HTTPMessage ret = null;
        IMessage converted = super.process(msg);
        try {
            WorkflowMessage wpcl = this.getWPCL(msg);
            Document document = XMLDocumentUtility.loadXml((String)converted.getPayload().getContent());
            String profileDir = this.getJobProfile(wpcl);
            this.addProfileDir(document, profileDir);
            String dir = this.getDestinationDir(wpcl);
            String outputTag = this.getOutputTag(wpcl).trim();
            this.addOutputDirNode(document, outputTag + OUTPUT_TAG_SUFFIX, dir);
            HTTPPayload payload = new HTTPPayload(XMLDocumentUtility.convertToString((Node)document));
            ret = new HTTPMessage(payload);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        return ret;
    }

    protected WorkflowMessage getWPCL(IMessage message) throws Exception {
        Document document = XMLDocumentUtility.loadXml((String)message.getPayload().getContent());
        WorkflowMessage wpcl = Unmarshaller.unmarshal((Document)document);
        return wpcl;
    }

    protected String getJobProfile(WorkflowMessage wpcl) {
        return wpcl.getValue(JOB_PROFILE_WPCL_KEY);
    }

    protected String getDestinationDir(WorkflowMessage wpcl) {
        return wpcl.getValue(DEST_DIR_WPCL_KEY);
    }

    protected String getOutputTag(WorkflowMessage wpcl) {
        return wpcl.getValue(OUTPUT_TAG_WPCL_KEY);
    }

    protected void addProfileDir(Document document, String profile) throws HandlerException {
        IHandlerConfiguration conf = this.getConfiguration();
        if (profile == null || profile.length() == 0) {
            throw new HandlerException("Job profile is missing");
        }
        String key = conf.getParameterValue("PROFILE_DIR_ELEMENT");
        String ext = conf.getParameterValue("JOB_PROFILE_EXT");
        String value = conf.getParameterValue("PROFILE_DIR") + profile + ext;
        logger.debug((Object)("Setting profile dir " + key + " to " + value));
        try {
            Node node = this.getProfileDirNode(document);
            node.setTextContent(value);
            document.getDocumentElement().appendChild(node);
        }
        catch (Exception e) {
            throw new HandlerException("Failed to add profile directory to message", (Throwable)e);
        }
    }

    protected Node getProfileDirNode(Document document) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate("//profile-dir", document, XPathConstants.NODE);
        return node;
    }

    protected void addOutputDirNode(Document document, String name, String dir) {
        Element node = document.createElement(name);
        node.setTextContent(dir);
        document.getDocumentElement().appendChild(node);
    }
}

