/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.log4j.Logger;

public class MessageQueue {
    private static final Logger logger = Logger.getLogger(MessageQueue.class);
    private UnboundedFifoBuffer msgList;

    public MessageQueue() {
        this.init();
    }

    private void init() {
        this.msgList = new UnboundedFifoBuffer(100000);
        logger.info((Object)"MessageQueue initialized");
    }

    public int getSize() {
        return this.msgList.size();
    }

    public synchronized void addMessage(Object newMessage) {
        this.msgList.add(newMessage);
        this.notify();
    }

    public synchronized Object getMessage() {
        while (this.msgList.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.msgList.remove();
    }

    public boolean isEmpty() {
        return this.msgList.size() == 0;
    }
}

